/*  XFC: Xfce Foundation Classes (User Interface Library)
 *  Copyright (C) 2004-2005 The XFC Development Team.
 *
 *  radiomenuitemsignals.cc - Gtk::RadioMenuItem virtual signal handlers
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "radiomenuitem.hh"
#include "radiomenuitemsignals.hh"
#include "private/radiomenuitemclass.hh"

using namespace Xfc;

/*  Gtk::RadioMenuItemSignals
 */
 
Gtk::RadioMenuItemSignals::RadioMenuItemSignals(RadioMenuItem *radio_menu_item) 
: CheckMenuItemSignals(radio_menu_item)
{
}

Gtk::RadioMenuItemSignals::~RadioMenuItemSignals()
{
}

void
Gtk::RadioMenuItemSignals::on_group_changed()
{
	GtkRadioMenuItemClass *g_class = RadioMenuItemClass::get_parent_class(instance_);
	if (g_class && g_class->group_changed)
		g_class->group_changed((GtkRadioMenuItem*)instance_);
}

